set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '420',
      '21',
      NULL,
      7,
      '1024420',
      14.550882,
      NULL,
      NULL,
      NULL,
      '443420',
      4.376230,
      '11-27-1992',
      4,
      8.633158,
      NULL,
      NULL,
      1.956567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828029,
      2,
      1.981260,
      0.882736,
      6.353816,
      1,
      0.048682,
      0.709704,
      3,
      2.877050,
      4,
      0,
      NULL,
      1,
      1,
      0.621103,
      6.243591,
      0,
      3.470480,
      3,
      NULL,
      0.784551,
      NULL,
      NULL,
      1.875901,
      NULL,
      NULL,
      3,
      4.992793,
      3.633773,
      2.487981,
      2,
      3,
      NULL,
      1.788960,
      0,
      2,
      0.078042,
      NULL,
      1.238379,
      0,
      0.186079,
      2.325793,
      0,
      NULL,
      NULL,
      3,
      1.295379,
      5,
      2,
      0,
      0,
      3.963792,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.995559,
      4,
      0.245204,
      5.271827,
      1.262793,
      2,
      NULL,
      NULL,
      0.480151,
      1,
      NULL,
      NULL,
      4,
      1,
      0.050083,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      4,
      4,
      1.919210,
      NULL,
      3.313590,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.231496,
      0.536589,
      3.338370,
      3.931719,
      0.230942,
      NULL,
      NULL,
      5.799913,
      2,
      2,
      1,
      0.674218,
      2,
      NULL,
      3,
      0,
      0.421673,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152316,
      0.721164,
      1,
      1,
      0,
      0.923482,
      0.703834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455101,
      NULL,
      NULL,
      0.045191,
      0.447075,
      3,
      1.480844,
      1,
      2,
      3,
      1,
      1,
      0,
      0.726458,
      NULL,
      NULL,
      0.763434,
      NULL,
      1,
      2.373852,
      1.779719,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.261350,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414683,
      NULL,
      3,
      1.350988,
      0.640847,
      0.894051,
      0.875855,
      3.917368,
      0,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.138173,
      1,
      NULL,
      1.267863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13440',
      NULL,
      '',
      0.711436,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.420178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


