set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      '42',
      3,
      3,
      NULL,
      9,
      3,
      0,
      3,
      NULL,
      0.245871,
      '11-28-2002',
      2.294790,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      0.184381,
      3.374021,
      0,
      1,
      3,
      0,
      1.951775,
      2.487307,
      0,
      1.754911,
      NULL,
      4,
      4,
      5.045760,
      1,
      1,
      0.412530,
      1,
      1.060382,
      7,
      1,
      2.696284,
      3.122314,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012285,
      NULL,
      NULL,
      NULL,
      5,
      1.050676,
      3,
      1.514831,
      NULL,
      NULL,
      1.636991,
      0,
      2.464889,
      1,
      1.742759,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.249989,
      1,
      3,
      0,
      0,
      4,
      1,
      0,
      0.569620,
      1.325503,
      NULL,
      NULL,
      1.206386,
      NULL,
      NULL,
      1,
      2.703606,
      NULL,
      NULL,
      NULL,
      NULL,
      2.159244,
      0.503714,
      0,
      1.025985,
      1,
      0.292376,
      1,
      NULL,
      NULL,
      0,
      0.826569,
      1,
      NULL,
      NULL,
      NULL,
      2.114288,
      3.247895,
      2.876038,
      1.990327,
      NULL,
      0,
      NULL,
      0.931426,
      0,
      1.549496,
      NULL,
      0,
      1.194026,
      0,
      1.205001,
      3,
      1.452554,
      NULL,
      1,
      6.509691,
      9.261314,
      5,
      6.802657,
      6,
      0.714722,
      2,
      6.730673,
      2.908407,
      0.545416,
      1.821459,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.587603,
      1,
      0.572679,
      0.550166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3.274293,
      NULL,
      2,
      1.792695,
      NULL,
      NULL,
      NULL,
      1.086555,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111827,
      0.868725,
      0,
      0.115173,
      1,
      0.127104,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.076620,
      1,
      0,
      0.538901,
      1.600240,
      1.387196,
      NULL,
      0.379782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.040779,
      '34021',
      '44414',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


