set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      NULL,
      9,
      21.848834,
      '4311042',
      24.571791,
      4,
      NULL,
      3,
      '010404',
      0.109348,
      ' 8- 0-2003',
      65,
      17,
      1,
      NULL,
      2.778911,
      1,
      3,
      0,
      1,
      1.257901,
      NULL,
      1.951259,
      1,
      NULL,
      3.396919,
      1.273387,
      1.268979,
      1.447773,
      0.638085,
      3.715394,
      4,
      NULL,
      0,
      1,
      0,
      0.694195,
      7,
      NULL,
      NULL,
      0.133020,
      1.309870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815299,
      1,
      2.980390,
      0.059869,
      1,
      1.981621,
      3.159166,
      0.734060,
      0,
      1,
      1,
      0,
      0.620787,
      0.491692,
      3.780425,
      NULL,
      3,
      0,
      2.403411,
      3.108398,
      1,
      NULL,
      7,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1.349629,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.298342,
      NULL,
      1.382436,
      0.265781,
      1,
      1,
      0.167285,
      1.505011,
      0.703938,
      1.862678,
      1,
      1.917004,
      1.951710,
      0.352285,
      NULL,
      NULL,
      1,
      2.820333,
      0.669125,
      NULL,
      0.544318,
      1.736901,
      0.860854,
      0,
      1.364241,
      1,
      1.459634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.739001,
      6,
      6,
      3,
      0,
      0.608169,
      6.394398,
      5.491320,
      3.840005,
      NULL,
      NULL,
      5.596078,
      0,
      1.227803,
      0.927019,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.760355,
      0.318051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148534,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.699412,
      NULL,
      NULL,
      NULL,
      NULL,
      3.277724,
      0.213659,
      1.439688,
      1.029678,
      0,
      NULL,
      0.584669,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.912432,
      3,
      NULL,
      3,
      1.924382,
      3.622904,
      1,
      3,
      3.825430,
      0,
      NULL,
      1,
      1,
      1.711434,
      0.374441,
      0,
      0.359867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      0.254776,
      NULL,
      '',
      '',
      0.143379,
      NULL,
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


