set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00',
      31,
      NULL,
      '0302010',
      NULL,
      3,
      3,
      1,
      '130121',
      3,
      ' 3- 2-1993',
      NULL,
      35.555928,
      1,
      NULL,
      0.760844,
      NULL,
      1.551068,
      NULL,
      1,
      1,
      0,
      1.972077,
      0.536247,
      0.256046,
      4,
      0.250227,
      0,
      1.996187,
      NULL,
      4.258800,
      NULL,
      NULL,
      1.929621,
      0.117868,
      0.629530,
      1.687499,
      3,
      0,
      3.963667,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.180957,
      5,
      1.222630,
      1.593610,
      0.788019,
      3,
      NULL,
      1.459555,
      NULL,
      3.926474,
      3,
      0,
      0.771229,
      1.858942,
      2,
      0,
      2.554051,
      3,
      NULL,
      3.633076,
      1.156762,
      0,
      5,
      1,
      0,
      0,
      0.326418,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.644926,
      0,
      NULL,
      0,
      0,
      0.294444,
      NULL,
      1.800330,
      1,
      0.744644,
      0.365661,
      NULL,
      0,
      0.886956,
      0,
      1,
      0.485774,
      0,
      1,
      NULL,
      0.046496,
      NULL,
      0.866195,
      1,
      0,
      0.477943,
      0.626996,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.323614,
      1.579577,
      0,
      NULL,
      5.108973,
      4,
      6,
      9,
      NULL,
      0,
      6,
      0.913548,
      NULL,
      NULL,
      1.680679,
      0.076974,
      0.409395,
      2,
      0.034698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.763236,
      0,
      0.995612,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.726545,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.816871,
      1.528627,
      1,
      0,
      0,
      0.195837,
      NULL,
      NULL,
      NULL,
      1.228888,
      3.629650,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.297503,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.193785,
      NULL,
      1,
      0,
      NULL,
      0.105552,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.642983,
      '31020',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.844581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


