set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '1',
      35.879472,
      11,
      '3443400',
      22,
      1,
      0,
      1,
      '323101',
      2.453478,
      '11- 6-2000',
      32,
      27.291937,
      0.764473,
      NULL,
      0,
      1,
      1,
      0.969035,
      1,
      NULL,
      1,
      0.192904,
      0,
      NULL,
      1.339001,
      NULL,
      1,
      0,
      0.086655,
      1.990113,
      7,
      1,
      0.700585,
      0,
      1.260418,
      1.762403,
      4,
      0,
      1.598042,
      3,
      1,
      0.373533,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.010954,
      1.303012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804501,
      1.065366,
      0.896341,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.059541,
      1,
      0.687289,
      NULL,
      0.885769,
      1,
      NULL,
      NULL,
      0.130924,
      NULL,
      1.942318,
      1,
      1.804141,
      0,
      1.433112,
      NULL,
      1,
      1,
      NULL,
      1.135781,
      NULL,
      2.751670,
      1.698640,
      0.485944,
      NULL,
      0.366659,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.587670,
      0.212914,
      1,
      0,
      1.310628,
      NULL,
      4,
      4.269846,
      1,
      0.822718,
      NULL,
      NULL,
      0,
      2,
      1,
      2,
      1.445388,
      0,
      5.557453,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.204177,
      1,
      1,
      1,
      NULL,
      1,
      1.803165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.059682,
      1,
      0.339183,
      NULL,
      NULL,
      2.940448,
      6,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.588589,
      1.009030,
      3,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.974481,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.330625,
      1.720327,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1.176933,
      1.806462,
      0,
      1.292959,
      0.151351,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.203818,
      '43010',
      '30303',
      NULL,
      0.282409,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      0,
      NULL,
      NULL,
      2,
      5.323589,
      3,
      NULL,
      2,
      1);
commit;
end;
/


