set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11421121',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.085328,
      2,
      '344210',
      5,
      NULL,
      26,
      43,
      0,
      NULL,
      0,
      NULL,
      1.346019,
      1.459454,
      NULL,
      NULL,
      0.722840,
      0.012055,
      1.473519,
      NULL,
      1.416605,
      1,
      0.510529,
      0.272562,
      1,
      0.305097,
      3,
      0,
      0.618646,
      0.392978,
      0.288141,
      NULL,
      NULL,
      0,
      1.300740,
      2.915805,
      0,
      0.124432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783717,
      NULL,
      1.702815,
      1.371875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040034,
      0,
      0,
      1,
      0,
      1,
      1.578267,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0.676811,
      NULL,
      0.597530,
      NULL,
      1.578120,
      1,
      0,
      NULL,
      NULL,
      0.754733,
      1.036674,
      1.387111,
      NULL,
      1.471566,
      0.527421,
      NULL,
      0.779872,
      1.352914,
      NULL,
      4,
      2.817578,
      0.798121,
      5.006706,
      4,
      0,
      7,
      4.260872,
      0.665034,
      NULL,
      1,
      1,
      NULL,
      1.857256,
      NULL,
      1.037399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.726892,
      NULL,
      0,
      0.726540,
      0,
      0.742871,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892304,
      NULL,
      NULL,
      NULL,
      NULL,
      2.489783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.669229,
      0.104602,
      3.400650,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.543991,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.382641,
      NULL,
      0,
      0.868077,
      1.196485,
      1,
      1.572780,
      0.623431,
      0.150272,
      0.157634,
      0,
      1.836882,
      1,
      1.172348,
      1.772670,
      0,
      0,
      1.223934,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.380850,
      '00244',
      '40104',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      4,
      7,
      1.321357,
      4,
      2.934585,
      2.867522,
      1.361668,
      1.221570,
      NULL);
commit;
end;
/


