set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '20323430',
      2.104268,
      NULL,
      '4210431',
      55,
      6,
      3.377333,
      2,
      '012214',
      2,
      ' 0- 8-1999',
      4.016355,
      36,
      1,
      NULL,
      0.181940,
      1,
      0,
      0.753856,
      NULL,
      1.415025,
      0,
      NULL,
      0,
      0.422106,
      0.044893,
      1,
      NULL,
      4.305236,
      1.144141,
      1,
      3.269111,
      4,
      3.388654,
      4,
      0,
      0.569037,
      2,
      NULL,
      3,
      0,
      1.828873,
      1.779018,
      NULL,
      NULL,
      1.797983,
      NULL,
      NULL,
      6.711341,
      9.697575,
      1.328258,
      0.321581,
      NULL,
      NULL,
      NULL,
      3.483113,
      2,
      0,
      NULL,
      0.998135,
      3.107252,
      1.762683,
      1,
      NULL,
      0.451178,
      2,
      0.205564,
      1,
      1,
      NULL,
      0,
      1,
      2,
      2.434002,
      0,
      NULL,
      NULL,
      0.294394,
      NULL,
      NULL,
      1,
      NULL,
      0.308946,
      NULL,
      0.082139,
      1,
      1,
      1,
      1,
      1,
      0,
      1.558015,
      1,
      0,
      0,
      0,
      0,
      1.453999,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470497,
      0.531542,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182433,
      1,
      1,
      1.491670,
      1.885552,
      0,
      5.864568,
      1,
      1,
      4.368971,
      4.171455,
      0.009403,
      NULL,
      NULL,
      NULL,
      3.224854,
      0.914002,
      0,
      6.247003,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924864,
      0,
      2,
      1,
      0.549492,
      1.113364,
      1.966534,
      0.503345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.186619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.388786,
      0.583420,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.504330,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985908,
      0.912170,
      NULL,
      2.733075,
      3,
      1,
      NULL,
      NULL,
      0.181030,
      2,
      1.991107,
      NULL,
      1,
      1.742026,
      1,
      0,
      1,
      1.790884,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '43320',
      '',
      0,
      '',
      '',
      '',
      1.614254,
      '',
      '',
      NULL,
      2,
      NULL,
      1,
      4.529589,
      NULL,
      2.741743,
      1,
      3.212607,
      3);
commit;
end;
/


