set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '40234330',
      51,
      NULL,
      '4143220',
      86.459878,
      3,
      0,
      2,
      NULL,
      0.885249,
      ' 9-19-1990',
      41,
      40,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.982827,
      1,
      1,
      1.359372,
      1,
      NULL,
      1,
      1,
      0.101271,
      0.700307,
      1,
      NULL,
      1.384656,
      0.493075,
      4.295819,
      NULL,
      NULL,
      7.824384,
      1,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      1.244268,
      NULL,
      NULL,
      9,
      7,
      1.046590,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      2.967659,
      2.477366,
      1,
      0.805797,
      0,
      2.733125,
      0.110706,
      NULL,
      NULL,
      0,
      3,
      0,
      2,
      NULL,
      0.167971,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.341815,
      0,
      0.382840,
      1,
      0,
      0.516620,
      1,
      NULL,
      0,
      0.823697,
      0.101749,
      NULL,
      0.357008,
      0,
      1,
      0.375580,
      NULL,
      0.114315,
      NULL,
      0.067095,
      NULL,
      1.158281,
      0,
      1.267118,
      0.694560,
      1.556868,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.715626,
      0,
      0,
      1,
      0.828515,
      5,
      NULL,
      NULL,
      1.722234,
      2,
      NULL,
      7.545512,
      NULL,
      5.637546,
      4.211555,
      0,
      1,
      NULL,
      6.881442,
      1.538181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.652864,
      NULL,
      1,
      0.251326,
      0.411465,
      1.532832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      4.997460,
      3.137376,
      0.429157,
      2,
      0.971542,
      NULL,
      NULL,
      NULL,
      1,
      0.499952,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.810133,
      1.734860,
      3,
      0,
      1,
      1.693301,
      0,
      3.142078,
      0.722261,
      0,
      0.041309,
      NULL,
      0.862404,
      1.777890,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.361455,
      '12404',
      '24442',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      3.401636,
      1,
      1,
      NULL,
      3,
      4,
      3,
      2,
      3);
commit;
end;
/


