set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00332344',
      NULL,
      80,
      '1411120',
      NULL,
      1,
      NULL,
      1,
      '340112',
      0,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      0.461768,
      0.423016,
      NULL,
      1.198150,
      1.834015,
      NULL,
      NULL,
      3,
      0.697294,
      0,
      6,
      4.436331,
      4.421855,
      NULL,
      NULL,
      0,
      5,
      NULL,
      3,
      5,
      0.177966,
      0.015558,
      4.222398,
      0,
      3.049019,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.972109,
      NULL,
      2,
      0.101164,
      1.175153,
      1.592285,
      3,
      3.347563,
      2.089063,
      3.528760,
      1,
      1.638884,
      0,
      0.017982,
      NULL,
      1.111924,
      0,
      3.248666,
      3.352903,
      1.436233,
      0.588123,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.145598,
      NULL,
      NULL,
      1.714191,
      NULL,
      NULL,
      0,
      1.012091,
      1,
      1,
      0.327036,
      1.225283,
      NULL,
      1.406079,
      0.310734,
      1,
      0.666178,
      1.431225,
      1,
      3,
      NULL,
      NULL,
      0,
      0.057671,
      NULL,
      NULL,
      1,
      1.283423,
      0,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309841,
      1,
      NULL,
      1,
      NULL,
      2.156456,
      NULL,
      5.107379,
      6,
      1.785662,
      3.179733,
      3.819036,
      NULL,
      2,
      0,
      NULL,
      0,
      0.451710,
      0.316929,
      0,
      1.270727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560170,
      1.665432,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.641057,
      1,
      0.402312,
      3.068434,
      0,
      NULL,
      3.383132,
      3,
      0,
      2,
      1.870987,
      NULL,
      NULL,
      NULL,
      1.233164,
      0.522939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870859,
      1.276614,
      1,
      0,
      1.839188,
      1,
      1.529885,
      1.968772,
      1,
      NULL,
      1.072320,
      1,
      NULL,
      0.998824,
      0.784080,
      1,
      1.235155,
      1,
      0.113855,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '23101',
      '01231',
      '',
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.098464,
      5,
      1.828952,
      2,
      1.343765,
      NULL,
      3,
      NULL,
      0.127002);
commit;
end;
/


