set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4432',
      '02004041',
      18,
      2,
      '0404443',
      63,
      NULL,
      3,
      0,
      '121404',
      4.446022,
      ' 2-19-1988',
      37.060256,
      15.162675,
      0.267903,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.320768,
      0.176901,
      NULL,
      0,
      NULL,
      0,
      3,
      1.882655,
      0,
      2,
      NULL,
      NULL,
      6.644508,
      0.925278,
      3.333871,
      3.412466,
      0.509155,
      1,
      0,
      NULL,
      NULL,
      1.676282,
      0.093398,
      1.562533,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.093392,
      3,
      0,
      NULL,
      1,
      0,
      0.743313,
      2,
      1.378069,
      3.637776,
      0,
      1.046187,
      0,
      0,
      0,
      0,
      3,
      3.833583,
      NULL,
      1.383299,
      1,
      NULL,
      4.331927,
      NULL,
      NULL,
      0.307580,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791669,
      1.633015,
      1.718858,
      0.235331,
      0.732108,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      1.671912,
      0,
      0,
      0.964383,
      1,
      1,
      1,
      0.388649,
      NULL,
      1.223401,
      0,
      NULL,
      NULL,
      1,
      0,
      0.215939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006777,
      0,
      1.318535,
      NULL,
      0.354850,
      0,
      NULL,
      4,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      2.103104,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303187,
      NULL,
      NULL,
      NULL,
      0.554269,
      1,
      1,
      1.606517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541718,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.299904,
      0.509639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.160507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256944,
      2.694035,
      0,
      0,
      3.759924,
      3.814108,
      0,
      1.498042,
      1.881159,
      2,
      0.379078,
      1.435252,
      0,
      NULL,
      0.952518,
      1,
      1,
      1.254559,
      0.268167,
      1.150473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '14423',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      1.153670,
      NULL,
      3,
      2.692601,
      4,
      3.385582,
      1,
      2.630703);
commit;
end;
/


