set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04302001',
      88,
      32.040800,
      '1312103',
      70.371592,
      1,
      0.104637,
      3,
      '200012',
      1,
      ' 9-11-1982',
      20.648776,
      NULL,
      1.552871,
      NULL,
      0.153355,
      0,
      NULL,
      0.161518,
      1,
      0,
      0,
      3.642737,
      0.785548,
      0,
      0.419815,
      1.626651,
      0.687956,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      5,
      0.607541,
      0.258144,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.274259,
      NULL,
      NULL,
      0.700929,
      NULL,
      NULL,
      5.707294,
      0,
      NULL,
      2.666355,
      NULL,
      1.841955,
      0,
      1,
      NULL,
      3.125217,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.197444,
      1,
      1,
      0.986013,
      NULL,
      3,
      0,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.676466,
      0.965903,
      NULL,
      1,
      2.500341,
      1,
      NULL,
      0,
      0,
      3,
      3,
      1,
      1.361567,
      1.213931,
      0.694556,
      1.267444,
      1.890343,
      1,
      1,
      NULL,
      0,
      0.025706,
      0.199006,
      0,
      0,
      1,
      NULL,
      1,
      0.574761,
      1.829085,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.281126,
      NULL,
      0,
      7.382157,
      NULL,
      7,
      NULL,
      1.230320,
      1.831680,
      NULL,
      NULL,
      NULL,
      2,
      1.382472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372732,
      1.275901,
      NULL,
      NULL,
      NULL,
      0,
      1.631814,
      0.239457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263656,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.181885,
      NULL,
      1,
      4,
      1,
      1,
      0.479534,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614972,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189483,
      1,
      3.015494,
      1.388256,
      0.364898,
      2,
      1.609379,
      0,
      1,
      3.077228,
      0,
      0.345454,
      1,
      1,
      0,
      0,
      0.426400,
      NULL,
      0.516606,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '31214',
      '40022',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      3.896950,
      NULL,
      5,
      1,
      0.448833,
      0.826489,
      NULL,
      3.509498);
commit;
end;
/


