set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1234',
      '20304031',
      58.229582,
      66.304477,
      NULL,
      32.078608,
      NULL,
      NULL,
      3,
      '310204',
      3.945937,
      ' 9-27-1993',
      38.672288,
      14.717895,
      1,
      NULL,
      0.549978,
      1,
      0,
      1,
      1.154395,
      1,
      1.667824,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.036615,
      6,
      NULL,
      1.992355,
      7,
      1,
      2,
      0.362557,
      1.850791,
      NULL,
      1.073208,
      1,
      1.059691,
      1,
      2,
      0,
      NULL,
      NULL,
      1.309017,
      NULL,
      NULL,
      0,
      1,
      0.508539,
      0,
      0.718200,
      1,
      1,
      NULL,
      3.483405,
      NULL,
      1,
      NULL,
      3.634973,
      1.572519,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.591073,
      0,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.218134,
      NULL,
      NULL,
      NULL,
      0.079860,
      3.386400,
      NULL,
      3.218670,
      1.628438,
      2,
      1,
      0.150056,
      NULL,
      1,
      0,
      1.157391,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.016333,
      3.722565,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.667320,
      1,
      1.006938,
      1.567922,
      1,
      0.376615,
      0,
      0,
      5.051631,
      0,
      6,
      2,
      0.520708,
      3.997510,
      2,
      NULL,
      1,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1.794829,
      0.574241,
      0.422882,
      1.632032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.256545,
      0.253736,
      3.367248,
      0,
      1.944170,
      0.139155,
      3,
      0,
      1.306095,
      0.284754,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174800,
      2,
      0,
      0.923566,
      3.614740,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0.696702,
      1.962497,
      NULL,
      1.564547,
      0.155731,
      NULL,
      0.993788,
      1.353943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42004',
      '11001',
      '',
      0.156005,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0.676364,
      2.877643,
      1,
      1,
      1.039545,
      3.441405,
      3,
      0,
      0.556660);
commit;
end;
/


