set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9539650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1144',
      NULL,
      53,
      4,
      '0243424',
      10.726396,
      4,
      NULL,
      2,
      '201323',
      2.985812,
      ' 1- 9-2000',
      0,
      17.913178,
      1,
      NULL,
      2.591319,
      1.312541,
      0,
      0.368260,
      0,
      0.592234,
      1.510251,
      1.926689,
      0.574131,
      0.778485,
      NULL,
      1,
      1.277640,
      0.256727,
      1.878985,
      0.825779,
      5,
      1,
      0.678252,
      0.547137,
      1.014912,
      0.601413,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0.702316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.410021,
      4.175913,
      0,
      NULL,
      0,
      0.481703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764996,
      3,
      1.712505,
      NULL,
      0,
      0.852040,
      NULL,
      0.322419,
      1,
      0,
      1,
      0.244829,
      0.372033,
      0.693374,
      NULL,
      0.305444,
      1,
      1.781062,
      NULL,
      0.395691,
      3.319398,
      0,
      0.551030,
      1.746157,
      1,
      1,
      1,
      2.342048,
      0.356256,
      1,
      0,
      5.811693,
      1.074554,
      3,
      0.758531,
      0.249859,
      4.670499,
      NULL,
      5.176399,
      NULL,
      NULL,
      1,
      2,
      0,
      5.836338,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.225538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427926,
      1.746929,
      NULL,
      0,
      0.902449,
      0.310105,
      1.379355,
      1.125357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822301,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3,
      0.536823,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.044263,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.649553,
      3,
      NULL,
      2,
      NULL,
      2,
      1,
      0,
      1.926891,
      1,
      1,
      NULL,
      0,
      0.194025,
      0.803894,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.574183,
      '01122',
      NULL,
      '32402',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      2.086539,
      NULL,
      1,
      2.810043,
      0,
      0,
      NULL,
      3,
      0);
commit;
end;
/


