set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9539650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3344',
      '34043004',
      NULL,
      73,
      '2040132',
      NULL,
      3,
      2.784450,
      1,
      '242230',
      NULL,
      NULL,
      NULL,
      21.038752,
      1.842047,
      NULL,
      NULL,
      1,
      0.133651,
      1.686844,
      NULL,
      2.401271,
      1.673448,
      0,
      1.539104,
      0.120422,
      0.362988,
      0.085105,
      1,
      NULL,
      0,
      NULL,
      0,
      0.663468,
      1.792861,
      1,
      1.541257,
      0,
      5.956086,
      1,
      3,
      NULL,
      0.541878,
      1,
      NULL,
      NULL,
      1.608517,
      NULL,
      NULL,
      NULL,
      0.009131,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771009,
      NULL,
      NULL,
      0.732511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.230070,
      0.463651,
      3.768656,
      1.019734,
      0.249373,
      0.876233,
      NULL,
      NULL,
      1.600950,
      1,
      1.405224,
      1,
      1,
      NULL,
      NULL,
      0.500897,
      1.287819,
      NULL,
      1.544336,
      5.801166,
      1.966237,
      NULL,
      0,
      0.327710,
      NULL,
      1.914037,
      5.463806,
      NULL,
      0.287870,
      0.832895,
      1.752450,
      0.646269,
      2,
      1,
      0,
      4.156687,
      4,
      NULL,
      1,
      1.890219,
      NULL,
      NULL,
      3.237920,
      3.378920,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458007,
      NULL,
      NULL,
      NULL,
      NULL,
      2.716978,
      2,
      2.576848,
      0.463651,
      1.698095,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599639,
      0,
      0.853619,
      4.589517,
      1.140555,
      2,
      1.824180,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.135824,
      1,
      NULL,
      0,
      2.472878,
      1,
      1,
      0,
      0.248709,
      0,
      0.504086,
      0,
      NULL,
      NULL,
      0,
      0.548865,
      0.720899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.921671,
      '42144',
      NULL,
      '44040',
      NULL,
      '',
      '',
      NULL,
      3.762053,
      '22441',
      '',
      '',
      NULL,
      NULL,
      0.484473,
      0.794795,
      1,
      1.877649,
      3,
      3,
      NULL);
commit;
end;
/


