set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7411597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12410031',
      NULL,
      51,
      '0323033',
      NULL,
      NULL,
      1.983249,
      0,
      '120411',
      0.095502,
      ' 6- 8-1994',
      78.707306,
      32,
      0.830080,
      NULL,
      2,
      0,
      0.198928,
      0,
      0.481097,
      3.775726,
      2.016585,
      1.333926,
      0.377112,
      0,
      6,
      1,
      1.237518,
      7.218090,
      NULL,
      1.376029,
      2.950407,
      1.551822,
      3,
      1.468154,
      0,
      0.686880,
      NULL,
      1,
      4.570023,
      NULL,
      1.817427,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284153,
      1,
      NULL,
      2.978374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592205,
      0.838473,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.578000,
      0,
      1.054815,
      0.385446,
      0,
      0,
      2,
      1,
      0.041048,
      0,
      1,
      0.264018,
      NULL,
      1.285317,
      3.263732,
      1.653649,
      1.126627,
      1,
      NULL,
      3.781713,
      1.168006,
      NULL,
      NULL,
      1,
      3.097251,
      0.512012,
      1.873119,
      4,
      0,
      2,
      6,
      1.843252,
      8.957351,
      NULL,
      6,
      0,
      9.359026,
      9,
      4,
      NULL,
      3.547478,
      0,
      1,
      1.826089,
      4.158508,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544093,
      0.391350,
      1,
      0,
      0.267357,
      1.157293,
      5,
      1.750660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.468037,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.667095,
      0,
      1.354368,
      0,
      0.013860,
      NULL,
      NULL,
      1,
      NULL,
      1.252761,
      0.098998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338959,
      5.130118,
      0.300083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437582,
      NULL,
      2.579922,
      2.215820,
      1,
      0.604729,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0.428133,
      NULL,
      1,
      1,
      1.073085,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.964299,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      4.193266,
      NULL,
      2.617818,
      7.841241,
      1,
      0.849683,
      1.460760,
      1.222162,
      NULL);
commit;
end;
/


