set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '0101433',
      27.557216,
      NULL,
      2,
      2,
      '233033',
      2.989499,
      NULL,
      48.356432,
      NULL,
      0.626495,
      NULL,
      2,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1.350795,
      1,
      1,
      1,
      1,
      0.194682,
      3.935207,
      1.128613,
      NULL,
      1.537539,
      NULL,
      0,
      NULL,
      0,
      1.054834,
      5.041065,
      1,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      0.441304,
      1.603107,
      1.362573,
      1,
      1.069689,
      0,
      1,
      2.082340,
      0,
      1.751203,
      0.526822,
      1,
      0.766619,
      1,
      1.613682,
      0.968806,
      1,
      9,
      1,
      2,
      0.614646,
      0.822837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675849,
      NULL,
      2.803904,
      0,
      1.059120,
      NULL,
      1,
      1,
      1.974206,
      1.919764,
      0.704630,
      1.108154,
      0.723104,
      0,
      1,
      NULL,
      1,
      1.370658,
      0.852439,
      NULL,
      0,
      NULL,
      0,
      NULL,
      5.450070,
      1.362100,
      5,
      1.671033,
      0.592962,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5.661011,
      1,
      1,
      NULL,
      3.432345,
      0,
      4,
      NULL,
      NULL,
      1.025144,
      NULL,
      4,
      NULL,
      3,
      NULL,
      1.729719,
      1.480047,
      7.350902,
      1.304763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.111929,
      NULL,
      1,
      1,
      0.963332,
      1,
      1.120556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.025670,
      1,
      NULL,
      5.640624,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.778832,
      3.699292,
      1,
      NULL,
      1,
      0.086045,
      NULL,
      NULL,
      0.665025,
      1,
      1.841558,
      1.265999,
      1.129571,
      NULL,
      0.745084,
      NULL,
      1.331926,
      NULL,
      0.871105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '21013',
      '',
      '',
      1.613678,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


