set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '2444112',
      0.193581,
      4,
      2.512836,
      3,
      '041324',
      NULL,
      ' 6- 3-1986',
      0.095678,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.143885,
      1,
      1.632476,
      0,
      1,
      1.578774,
      1,
      1,
      0,
      0,
      1.682085,
      NULL,
      1.791744,
      1,
      0.944821,
      0.458286,
      0.066388,
      1.415944,
      0,
      NULL,
      2,
      0,
      4.412644,
      0.293784,
      0.174424,
      0.120204,
      NULL,
      NULL,
      1.796531,
      NULL,
      NULL,
      NULL,
      5.106925,
      NULL,
      2,
      0,
      0.955269,
      NULL,
      NULL,
      0.349301,
      0.583888,
      NULL,
      1,
      0.469975,
      0.507500,
      0.474783,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      5.732804,
      NULL,
      NULL,
      1.018759,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.605551,
      1.414230,
      1.905757,
      0.088015,
      1,
      0,
      0.878531,
      NULL,
      0.374217,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.815329,
      1.343796,
      0.308896,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.961877,
      2.131497,
      0,
      4,
      1.540953,
      1.684200,
      1.935986,
      NULL,
      1.079069,
      0.078465,
      NULL,
      NULL,
      7,
      8,
      8,
      1.479146,
      1,
      NULL,
      5.347911,
      6.461144,
      3.175902,
      NULL,
      NULL,
      2.418072,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.825321,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261323,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5.530966,
      1.679587,
      1.639661,
      3.624656,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.680268,
      1,
      0.001534,
      3.943570,
      3,
      1.261405,
      0,
      0.644950,
      3.518946,
      0,
      1.993070,
      1.657249,
      1.723298,
      0,
      0.948271,
      1.180351,
      1,
      NULL,
      0.819828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.170395,
      '14110',
      '',
      NULL,
      0.782661,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


