set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '1321124',
      73.842385,
      4,
      1.906999,
      2,
      '111303',
      0,
      ' 6-29-1988',
      NULL,
      NULL,
      0.223367,
      NULL,
      0,
      1.896607,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1.354090,
      6.622611,
      NULL,
      0.360055,
      0.757007,
      0.530113,
      7,
      0,
      1,
      1.369697,
      NULL,
      0,
      1,
      4,
      0,
      0,
      1.453125,
      3,
      0.518374,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.441628,
      NULL,
      NULL,
      1,
      1,
      0.097501,
      1,
      1.074715,
      2.511906,
      1,
      NULL,
      0.160825,
      0,
      0.813891,
      1,
      1.662600,
      1.932670,
      0.180757,
      1,
      1,
      NULL,
      2,
      NULL,
      2,
      0.705046,
      NULL,
      NULL,
      NULL,
      0.406842,
      NULL,
      NULL,
      1.679234,
      NULL,
      NULL,
      NULL,
      1.938146,
      1.636966,
      1,
      0.935893,
      0.759237,
      0.866175,
      0.014907,
      1.747621,
      NULL,
      1.734956,
      1,
      0.007885,
      0,
      NULL,
      0.563964,
      NULL,
      NULL,
      6.629651,
      0,
      1.269106,
      NULL,
      1.637642,
      3,
      1,
      3.894575,
      6.323553,
      NULL,
      1,
      7,
      NULL,
      NULL,
      0.621325,
      1,
      NULL,
      7,
      3,
      2,
      0.425229,
      1.541458,
      NULL,
      NULL,
      3,
      NULL,
      0.499569,
      1,
      1.230450,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304454,
      1.985837,
      NULL,
      1,
      1,
      1.938495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.233790,
      1,
      1.387963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358763,
      NULL,
      9.915851,
      7,
      NULL,
      0,
      3.130487,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671362,
      3,
      NULL,
      1.439164,
      0.753611,
      NULL,
      1.702828,
      1,
      0,
      NULL,
      3.897736,
      0.646026,
      1,
      0,
      0.038136,
      1,
      1,
      0.522514,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.814103,
      '14334',
      '',
      '',
      0.411602,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


