set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '0440021',
      59.167028,
      6,
      NULL,
      0,
      '243033',
      2,
      ' 9-24-1999',
      14,
      NULL,
      0,
      NULL,
      1.876980,
      NULL,
      1.780631,
      0.129733,
      NULL,
      0,
      1.299600,
      0,
      NULL,
      NULL,
      2.048409,
      1.614148,
      1,
      1.646641,
      0.695029,
      3.376628,
      7.610188,
      NULL,
      1.017548,
      3,
      0.203099,
      1.688699,
      NULL,
      0,
      1.914293,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.794375,
      1.504983,
      1.340231,
      0,
      0.977969,
      2.020124,
      0,
      3.424753,
      NULL,
      2.773623,
      NULL,
      1.091470,
      1.028097,
      0,
      0.943634,
      1,
      1,
      1,
      0.714210,
      1,
      NULL,
      1,
      0,
      0.712494,
      1,
      NULL,
      NULL,
      0.013070,
      NULL,
      NULL,
      1,
      1.031250,
      1.661605,
      0,
      0.263915,
      1,
      0,
      1,
      0.441420,
      1,
      NULL,
      NULL,
      0,
      0.451065,
      0.213470,
      1.995914,
      1,
      1,
      1,
      NULL,
      1,
      6,
      NULL,
      0.649588,
      1.601379,
      0,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3.486301,
      3.277306,
      NULL,
      0,
      NULL,
      0,
      2,
      0.281696,
      NULL,
      2.692059,
      1.266563,
      2.920649,
      1.583253,
      8,
      4,
      1.973049,
      NULL,
      NULL,
      0,
      0.720389,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.107081,
      0,
      1,
      1.882956,
      1.398201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.943130,
      NULL,
      8,
      1.238105,
      2,
      3.567561,
      0,
      NULL,
      0.909525,
      NULL,
      0,
      4.160735,
      2.391820,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.424750,
      6.714444,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6.100105,
      1.436502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.586499,
      NULL,
      1,
      1.828745,
      1.020834,
      0,
      0,
      NULL,
      3.345529,
      0,
      1.212793,
      0,
      NULL,
      NULL,
      1.547860,
      0.096663,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23012',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.026189,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


