set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '22',
      NULL,
      13.479327,
      '3030120',
      75,
      6,
      3.991528,
      2,
      '322023',
      NULL,
      '10- 4-2001',
      16.767254,
      14.223988,
      0,
      NULL,
      3,
      2,
      0,
      NULL,
      2.195453,
      0.202448,
      1.934900,
      1,
      1.231254,
      1,
      7,
      1,
      1,
      NULL,
      0.014827,
      7.794605,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.646271,
      4.716667,
      0,
      5.410630,
      NULL,
      3.544555,
      0.432383,
      NULL,
      NULL,
      1.184082,
      NULL,
      NULL,
      0,
      1,
      0,
      0.452524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559782,
      NULL,
      NULL,
      0.213209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.964637,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1.469680,
      0,
      1,
      1,
      0,
      NULL,
      0.698842,
      NULL,
      NULL,
      1.073530,
      1,
      1,
      0,
      1.175264,
      1.487125,
      0.429059,
      1,
      5.049249,
      NULL,
      0.074988,
      0.167048,
      1,
      0.616275,
      5.025240,
      0,
      7.315651,
      5,
      3,
      0.692828,
      3,
      4,
      5.025844,
      1.185321,
      4.902550,
      3,
      0,
      3.994970,
      1.766701,
      1.584790,
      1,
      2.064904,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.619106,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.751501,
      1,
      NULL,
      5.698068,
      2,
      1,
      1.157533,
      NULL,
      NULL,
      NULL,
      0,
      2.539779,
      0.297039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.046251,
      0.202075,
      1.769762,
      1.003153,
      1,
      0.809807,
      1.574355,
      3.305406,
      3.054239,
      1,
      0.130228,
      1.721850,
      0.106674,
      0.278290,
      1,
      1.640760,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '34304',
      '',
      '',
      1.156928,
      NULL,
      '',
      '',
      1.334381,
      '',
      '',
      '',
      2,
      NULL,
      3.695602,
      NULL,
      3.600201,
      NULL,
      1.760043,
      NULL,
      NULL);
commit;
end;
/


