set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '101',
      NULL,
      43,
      NULL,
      '1403221',
      203,
      1,
      NULL,
      NULL,
      '420211',
      3.235841,
      '11- 5-1998',
      1.082659,
      37.480698,
      1,
      NULL,
      1.629965,
      3.565432,
      0.287774,
      NULL,
      NULL,
      1,
      1,
      1.884740,
      0.377903,
      0.408589,
      NULL,
      0,
      0.489628,
      1.751245,
      1.301209,
      3,
      1,
      0.304953,
      1.524790,
      0.365498,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.074111,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.696188,
      0.123144,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625857,
      0.443083,
      NULL,
      0,
      0,
      NULL,
      1.900733,
      NULL,
      NULL,
      0.735425,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656004,
      3,
      2.303526,
      NULL,
      1,
      0,
      0,
      0,
      0.069861,
      1.789816,
      1.873605,
      1.459470,
      0.791061,
      0.505649,
      1,
      0,
      1,
      NULL,
      0,
      0.349720,
      1.401929,
      0,
      1.451679,
      NULL,
      1.803930,
      1.919834,
      0.087887,
      1,
      0.611076,
      NULL,
      1,
      NULL,
      1,
      1,
      5.987974,
      0,
      3,
      NULL,
      NULL,
      6,
      NULL,
      5.106805,
      6.716632,
      3,
      0.907572,
      2,
      2,
      0.264138,
      NULL,
      7.017877,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080840,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315286,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      1,
      0.917662,
      2,
      0.294726,
      NULL,
      NULL,
      NULL,
      1.650124,
      3.392875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.008282,
      1,
      1.838208,
      1.357470,
      NULL,
      3,
      0.221069,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0.886764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.485646,
      '24221',
      '',
      '',
      0.863150,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      2.630391,
      7,
      0,
      0.358808,
      0,
      2.541012,
      0.361517,
      NULL,
      2);
commit;
end;
/


