set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '23401111',
      37,
      NULL,
      '1141420',
      2.654530,
      2,
      3,
      0,
      '202103',
      5.834749,
      ' 7- 9-1995',
      NULL,
      14,
      1.579694,
      NULL,
      5.508510,
      3,
      1,
      0,
      3,
      1,
      0,
      1,
      NULL,
      1.171154,
      6,
      1.858261,
      1.395711,
      1.563777,
      1.872137,
      NULL,
      7.018138,
      0.871298,
      NULL,
      1,
      0,
      1.242881,
      3.207732,
      0,
      5.565837,
      1.424214,
      0.155652,
      0.741621,
      NULL,
      NULL,
      0.119514,
      NULL,
      4,
      9,
      1,
      1,
      2.713996,
      NULL,
      1,
      NULL,
      NULL,
      0.717629,
      NULL,
      2,
      1.600009,
      3,
      1,
      0,
      1.740087,
      0,
      1,
      1,
      1.338027,
      4.712272,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679885,
      1.485598,
      0.235190,
      NULL,
      0,
      1.656230,
      2.006702,
      NULL,
      0,
      1,
      NULL,
      0.959551,
      1.279050,
      0,
      0,
      1,
      0.718532,
      0,
      1.700797,
      1,
      0,
      0,
      NULL,
      1.920783,
      2,
      NULL,
      1.302295,
      3.241138,
      NULL,
      1,
      1.052379,
      0.668274,
      NULL,
      2.985516,
      NULL,
      NULL,
      1,
      2.511757,
      NULL,
      0.698386,
      1,
      7.403853,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.807496,
      0.654178,
      1,
      3,
      1,
      1.642264,
      0.328172,
      1.149580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174457,
      NULL,
      0,
      1,
      0.058088,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.760280,
      3,
      NULL,
      0.359407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      3.566777,
      4.619153,
      2,
      6,
      1.233558,
      NULL,
      NULL,
      3,
      NULL,
      3.679360,
      NULL,
      3,
      4,
      NULL,
      NULL,
      0.938113,
      1,
      3.220351,
      NULL,
      NULL,
      0,
      2,
      1.805690,
      NULL,
      0.099305,
      0,
      0.863383,
      NULL,
      0.142771,
      1,
      0.823740,
      1.636811,
      NULL,
      1.603495,
      1,
      1.445487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.145858,
      '31132',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      2.234533,
      2.834114,
      2.834947,
      NULL,
      3.611137,
      3.126448,
      NULL,
      2.363490);
commit;
end;
/


