set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      0,
      47.071643,
      '4441344',
      206.171280,
      NULL,
      NULL,
      3,
      '444101',
      2,
      ' 9- 6-2002',
      NULL,
      41.653696,
      NULL,
      NULL,
      NULL,
      3.831388,
      1,
      1,
      2.123761,
      0.953585,
      1,
      1.074403,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      3.688968,
      3,
      1.633438,
      0.349295,
      3.072240,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.469801,
      NULL,
      NULL,
      5,
      NULL,
      0.373242,
      NULL,
      0.761959,
      NULL,
      3.959001,
      NULL,
      1,
      0.624530,
      0.217531,
      2.070407,
      NULL,
      2,
      1,
      0.690612,
      3.019608,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.245479,
      1,
      2,
      1.809000,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.662413,
      0.131510,
      0,
      1,
      0,
      0.323084,
      NULL,
      1.203760,
      0.686057,
      NULL,
      1.678372,
      NULL,
      0.219988,
      NULL,
      NULL,
      NULL,
      5.938820,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0.505013,
      NULL,
      NULL,
      1.042101,
      NULL,
      1,
      0.404809,
      1.812260,
      0,
      6.273430,
      NULL,
      3,
      0,
      3.407692,
      5,
      1.273245,
      5.092326,
      3.193148,
      NULL,
      0,
      NULL,
      7.235158,
      1.553595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.812233,
      0,
      NULL,
      1.591270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.972447,
      NULL,
      NULL,
      NULL,
      0,
      0.456061,
      5,
      NULL,
      0,
      1,
      1.520442,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.596829,
      1.706809,
      1,
      2.365952,
      0.353159,
      1.643193,
      2.468693,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.208194,
      NULL,
      0.352815,
      1.640284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144657,
      '20022',
      '',
      NULL,
      0.933929,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.825573,
      5,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3);
commit;
end;
/


