set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '44302123',
      27,
      81.781446,
      '4400340',
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      ' 1-24-1983',
      NULL,
      40.563993,
      0,
      NULL,
      4,
      2,
      1,
      NULL,
      0.305410,
      1,
      1.855676,
      0.009902,
      3,
      0,
      NULL,
      0,
      NULL,
      0,
      0.735506,
      1,
      NULL,
      0,
      NULL,
      0.498138,
      1.993002,
      0.532589,
      2.911302,
      0,
      0.286475,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      4,
      1,
      1,
      1.325029,
      0.800461,
      NULL,
      1.142986,
      0.584339,
      NULL,
      2.148833,
      2,
      1,
      3.431582,
      NULL,
      1,
      NULL,
      0,
      1.866755,
      0,
      0.367434,
      0.640089,
      2.337202,
      1,
      NULL,
      0.457964,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.221692,
      1.993357,
      NULL,
      1.547579,
      1,
      NULL,
      0.101003,
      1.103534,
      NULL,
      0,
      1.775183,
      0,
      1.659477,
      1,
      NULL,
      1.383402,
      0.832894,
      1.060241,
      NULL,
      1.934027,
      4.576971,
      NULL,
      0,
      NULL,
      0.649233,
      4,
      NULL,
      NULL,
      1,
      0.126321,
      0.690718,
      0,
      1.314005,
      2,
      NULL,
      4.417166,
      NULL,
      3.009320,
      4,
      5.275138,
      5,
      1.456532,
      NULL,
      1,
      NULL,
      0.181364,
      1.892184,
      NULL,
      0,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711878,
      0.954431,
      1,
      NULL,
      1.761530,
      NULL,
      0.827742,
      1.808851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.810796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.348555,
      0.386833,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.007326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642938,
      0,
      NULL,
      3.374213,
      1.142059,
      NULL,
      0,
      0,
      1.315882,
      NULL,
      0,
      0.429307,
      NULL,
      0,
      0,
      1.004147,
      1.392091,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      4.980427,
      1,
      2.856478,
      2,
      3.907995,
      2.019873,
      3.122679,
      2,
      NULL);
commit;
end;
/


