set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '444',
      '10422112',
      41.212426,
      12.438817,
      '4110101',
      54,
      1,
      0,
      NULL,
      '030034',
      1,
      NULL,
      13.852055,
      15,
      1,
      NULL,
      4.304783,
      0.238135,
      0,
      1.610617,
      3.419636,
      0,
      0.565042,
      0,
      1,
      NULL,
      0.180941,
      NULL,
      0.213549,
      1.348720,
      NULL,
      7.126499,
      5,
      0,
      3,
      NULL,
      0,
      NULL,
      3.738955,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.813171,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190095,
      3,
      0,
      NULL,
      3,
      3.091001,
      0,
      3,
      NULL,
      3,
      0,
      0.123433,
      0,
      0.328732,
      2,
      0.867173,
      1.946291,
      1.493650,
      1.936223,
      0.146502,
      2.861637,
      0,
      NULL,
      0.583892,
      1.976895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.530157,
      1,
      1.842504,
      1.103911,
      1.620512,
      1.155224,
      0.033303,
      1.753089,
      0,
      0,
      0,
      1,
      0.586633,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      4.495102,
      0.677944,
      1.838360,
      NULL,
      0.437778,
      3.636896,
      0.948617,
      4,
      4,
      NULL,
      0,
      2,
      0.504153,
      1,
      NULL,
      4.739803,
      NULL,
      3.108989,
      0.032663,
      7.063007,
      8,
      NULL,
      6.065133,
      NULL,
      NULL,
      2,
      3.841067,
      0,
      0,
      1,
      9.864160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.527624,
      1.251561,
      1.285285,
      1.062385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873635,
      NULL,
      2.998552,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.776766,
      1,
      0,
      4.686132,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.100022,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.547220,
      NULL,
      1,
      0.324398,
      NULL,
      2,
      3.132449,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.898298,
      1.006950,
      NULL,
      0.261712,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      1.082463,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      4,
      3,
      3.479156,
      0,
      2.794589,
      NULL,
      3,
      1,
      1.390835);
commit;
end;
/


