set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13013113',
      NULL,
      71.639200,
      NULL,
      134.853498,
      0,
      2.378750,
      NULL,
      '221224',
      NULL,
      ' 5- 8-1990',
      NULL,
      20.000575,
      1,
      NULL,
      0,
      3.675076,
      1.729697,
      1,
      2.505744,
      0,
      1.894461,
      NULL,
      1.429180,
      0.205141,
      5,
      0.959541,
      0,
      0,
      0,
      0,
      5,
      0,
      NULL,
      NULL,
      0,
      0.769599,
      NULL,
      0,
      2.617553,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.948520,
      0.700938,
      3.828535,
      3,
      1.718754,
      0,
      NULL,
      2.121407,
      NULL,
      3,
      0.982924,
      3.478360,
      0.329653,
      1.231395,
      NULL,
      0,
      1.141190,
      0.161005,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2.623184,
      3.292244,
      1.236807,
      1.244733,
      1,
      0.303933,
      0,
      0,
      0,
      NULL,
      0,
      0.119146,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0.388557,
      NULL,
      NULL,
      1,
      2,
      0.330446,
      0,
      1,
      NULL,
      NULL,
      0,
      1.874137,
      4.658587,
      NULL,
      0.538342,
      5.556317,
      3,
      7,
      2.948739,
      5,
      3,
      2.655662,
      8.318426,
      4.873485,
      1,
      4,
      3.459699,
      NULL,
      0.947056,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.469288,
      0,
      0,
      0.281058,
      0,
      1,
      0.271834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.791410,
      NULL,
      6.611428,
      2,
      2,
      1.660561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      2,
      1,
      0.999313,
      NULL,
      NULL,
      NULL,
      0.876012,
      5.570154,
      0.230671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.485704,
      1.955253,
      1.328697,
      1.712626,
      0,
      0.790474,
      NULL,
      NULL,
      NULL,
      0,
      0.903469,
      NULL,
      NULL,
      1.499224,
      1.185384,
      1.641293,
      NULL,
      1.243864,
      1.086904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.632033,
      '31214',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '3420',
      '',
      '',
      0,
      6,
      1.201961,
      3.733747,
      NULL,
      3,
      1.888703,
      1.555356,
      3.840326);
commit;
end;
/


