set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1232',
      NULL,
      80.354856,
      NULL,
      '4411203',
      45.786345,
      4,
      0.193212,
      NULL,
      '012440',
      3,
      ' 6-11-1983',
      55.596543,
      12.972590,
      0.282794,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.445184,
      NULL,
      1,
      1.060308,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      6.308188,
      0,
      0.458283,
      0.229912,
      NULL,
      1,
      0.337951,
      1,
      1,
      0.069754,
      1.605695,
      2.024861,
      1.205121,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.854277,
      0,
      NULL,
      2.364532,
      NULL,
      0,
      1,
      3.058412,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.371258,
      0,
      0,
      NULL,
      1,
      0,
      0.523525,
      1.407652,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.047743,
      NULL,
      1,
      NULL,
      0.425722,
      0.962235,
      NULL,
      1.775039,
      0,
      1.089334,
      NULL,
      NULL,
      0.020057,
      NULL,
      NULL,
      1.622615,
      0,
      NULL,
      1.468918,
      NULL,
      NULL,
      2.738205,
      0,
      NULL,
      1,
      0.982508,
      NULL,
      NULL,
      5,
      0.187167,
      0.596793,
      1,
      4.974471,
      0.759172,
      NULL,
      0,
      4,
      1,
      3,
      2.082421,
      4,
      0,
      NULL,
      9.995032,
      5,
      3.589575,
      NULL,
      4.263898,
      0,
      1,
      1,
      3.552818,
      0.285882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774686,
      1,
      1,
      1,
      0.046461,
      1,
      0.896595,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.480596,
      NULL,
      2,
      1.986373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.156044,
      1.961035,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.542504,
      NULL,
      3.934875,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.380245,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834827,
      2.429366,
      2,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.274763,
      1,
      0,
      1,
      NULL,
      1,
      1.971022,
      0.369482,
      1.584156,
      0,
      1.284305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.801116,
      '40443',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1,
      '0130',
      '',
      '',
      3,
      3.471872,
      1.293911,
      NULL,
      3,
      2,
      3.893509,
      2,
      5.033767);
commit;
end;
/


