set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2423',
      NULL,
      96.556974,
      86,
      '3311034',
      22.162400,
      4,
      2,
      NULL,
      '142214',
      2.263604,
      ' 0-16-1994',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.079933,
      1,
      0.205578,
      0.011956,
      1,
      NULL,
      1,
      0.504751,
      NULL,
      0,
      0,
      0,
      0,
      4,
      0,
      1.721850,
      1,
      NULL,
      NULL,
      1.292470,
      4.388691,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1.638678,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221858,
      1,
      1.304962,
      1.450823,
      1,
      NULL,
      1.628963,
      2.068722,
      3,
      2.079806,
      1,
      0,
      0.758334,
      NULL,
      1,
      1.783927,
      0.666479,
      0,
      0.579052,
      1.409932,
      6,
      0,
      1,
      0,
      0.681207,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.494650,
      1,
      1.526478,
      1,
      NULL,
      0,
      0,
      1.483911,
      NULL,
      0.069755,
      1.117180,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.399423,
      NULL,
      NULL,
      0.584956,
      1.517358,
      5,
      1,
      2,
      1.231120,
      5,
      5.240753,
      4,
      1,
      NULL,
      1.356403,
      1,
      0.992299,
      NULL,
      7,
      6.230579,
      1.753461,
      2,
      0,
      6,
      NULL,
      NULL,
      4.596576,
      1,
      1.497800,
      0,
      3.478556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.775577,
      0.940957,
      1.981261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.317771,
      NULL,
      1.617388,
      NULL,
      NULL,
      NULL,
      0.182473,
      NULL,
      4.635693,
      6.600972,
      1,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      3,
      1.270089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024773,
      3,
      3,
      0.164642,
      0,
      3,
      2.326210,
      1.156957,
      1,
      2,
      0,
      NULL,
      0.790777,
      0.042704,
      0.163842,
      NULL,
      0.675582,
      1.265274,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.711459,
      '13323',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2,
      '0444',
      NULL,
      '',
      2.940216,
      NULL,
      0,
      2.965654,
      3,
      3,
      NULL,
      1,
      3.382572);
commit;
end;
/


