set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '24',
      45,
      15.943561,
      '0023213',
      NULL,
      0,
      2,
      0,
      '103323',
      NULL,
      ' 4-26-1989',
      32,
      24.744112,
      NULL,
      NULL,
      6.144467,
      1,
      0,
      1.382110,
      0,
      3,
      1,
      1.255973,
      0.663514,
      0.156041,
      NULL,
      NULL,
      2.686595,
      0.198364,
      NULL,
      1,
      1.845653,
      0.924070,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.570138,
      1,
      0,
      1.930778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380528,
      1.446119,
      0.220966,
      0.270252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734521,
      NULL,
      0,
      1,
      0,
      0,
      0.097292,
      0,
      0.057119,
      NULL,
      NULL,
      1.033288,
      NULL,
      1.253411,
      0.081337,
      NULL,
      0.243946,
      NULL,
      0,
      NULL,
      1.267244,
      5.803369,
      0,
      1.400011,
      NULL,
      4.785548,
      3,
      0.940932,
      3,
      0.625075,
      0,
      2.861095,
      5.422547,
      NULL,
      1.487363,
      0,
      0,
      3.401502,
      8,
      0,
      6,
      3.125464,
      NULL,
      NULL,
      7.207950,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.799389,
      1.180252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837720,
      1,
      0,
      1,
      NULL,
      1.048630,
      0.976474,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1.160910,
      2.199996,
      1.763693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.629525,
      7,
      3,
      5.238101,
      1,
      2.966482,
      NULL,
      NULL,
      NULL,
      0,
      0.573292,
      0.386630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.004556,
      1.672349,
      0,
      0.427479,
      0.079922,
      2.805283,
      1.273576,
      0.565317,
      NULL,
      0,
      0,
      NULL,
      0,
      0.610438,
      0,
      0,
      0.228845,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.673378,
      NULL,
      NULL,
      '',
      0.618338,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


