set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      NULL,
      25.672930,
      16,
      '0220232',
      131.086952,
      3,
      3.475660,
      2,
      '322244',
      0.668546,
      ' 0- 1-1992',
      58,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3,
      1.607128,
      0,
      3.832684,
      1.793446,
      0.323370,
      1.515557,
      1.226975,
      4.985637,
      0.894922,
      3,
      NULL,
      1,
      0,
      0.122847,
      0.774442,
      0.750657,
      NULL,
      1.143256,
      1,
      NULL,
      0,
      0.361406,
      NULL,
      0.749259,
      1.935324,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.533535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1.389965,
      NULL,
      1.700194,
      0.992019,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.725471,
      NULL,
      1.638386,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0.656915,
      2,
      1.217108,
      0.207987,
      1.724644,
      0.450893,
      0.406313,
      NULL,
      0.751903,
      1.723380,
      0,
      0,
      2,
      4.780999,
      2,
      0,
      3.817557,
      6,
      4,
      7.259457,
      0.376111,
      NULL,
      1,
      1.386148,
      NULL,
      NULL,
      3.748641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176543,
      0.729809,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.281177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.524869,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      0.601558,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      0,
      5,
      0,
      1.064392,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.314077,
      0.296947,
      3,
      NULL,
      3.634946,
      1.095164,
      0.536460,
      NULL,
      1,
      0,
      NULL,
      0,
      0.153740,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '12032',
      '',
      '',
      0.478671,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      5,
      NULL,
      3,
      1.191326,
      NULL,
      0,
      0.214868,
      0,
      NULL);
commit;
end;
/


