set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      NULL,
      21,
      9.049579,
      '3432422',
      94.988183,
      6,
      2,
      2,
      '322441',
      5.491409,
      ' 1-20-1998',
      30.647330,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.199071,
      0,
      1,
      NULL,
      0.112576,
      1,
      0,
      NULL,
      0.629272,
      0,
      1,
      NULL,
      1,
      2.473617,
      1.539009,
      1,
      1,
      NULL,
      0,
      1.617244,
      1,
      0,
      1.167346,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.703440,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0.374992,
      NULL,
      0,
      0.533864,
      1.500379,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.115718,
      NULL,
      0.268202,
      3.469864,
      1,
      0.222663,
      5,
      0,
      3.462500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077410,
      1,
      NULL,
      0.605533,
      0.312258,
      0.415244,
      2,
      1,
      NULL,
      9.888127,
      1,
      NULL,
      0,
      0.295891,
      1.818748,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452734,
      0,
      0,
      0,
      0.983911,
      0.004000,
      1,
      1.338203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.749510,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181576,
      NULL,
      NULL,
      1.486077,
      NULL,
      2,
      1.663620,
      NULL,
      NULL,
      NULL,
      0,
      1.104973,
      0.103315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.789711,
      0,
      0.531694,
      3,
      NULL,
      1,
      0,
      0,
      2,
      0.359001,
      NULL,
      1,
      NULL,
      NULL,
      0.790547,
      0.935711,
      NULL,
      0.208152,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.872547,
      '42132',
      '',
      '',
      0.482691,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      4.956106,
      NULL,
      5,
      0.136231,
      1,
      1.284593,
      0.921653,
      2.303644);
commit;
end;
/


