set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217062';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '341',
      '24011032',
      35.715753,
      16,
      '0324440',
      223.932462,
      NULL,
      1.448900,
      2,
      '341413',
      6,
      ' 9- 3-1997',
      43,
      29.460296,
      0.079053,
      NULL,
      0,
      NULL,
      1.208786,
      NULL,
      0,
      0,
      0.991292,
      NULL,
      NULL,
      0,
      1.627775,
      1,
      1,
      NULL,
      1.406973,
      0,
      0,
      NULL,
      1.642292,
      1.180211,
      0.723084,
      0.284488,
      NULL,
      1,
      1.643919,
      3.118741,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.238047,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.651488,
      1,
      1.759961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0.338328,
      NULL,
      NULL,
      1,
      1.194932,
      0.947258,
      0.038539,
      0,
      1,
      0.948350,
      NULL,
      NULL,
      0.466401,
      1,
      0,
      0.243556,
      1,
      1.005939,
      1.964561,
      3.164989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326431,
      1.193204,
      0,
      0.646228,
      3,
      5,
      0,
      NULL,
      0,
      NULL,
      7,
      0,
      NULL,
      1,
      0,
      0.203081,
      NULL,
      NULL,
      NULL,
      1.284082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608970,
      0.931184,
      2,
      0,
      1.255328,
      1,
      0,
      1.027793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.066177,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.851248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.597753,
      1.978993,
      0.146285,
      0.266446,
      1.329419,
      0,
      1,
      0.586510,
      2.086077,
      1.849979,
      1,
      0,
      0,
      0.966304,
      NULL,
      0.745584,
      0.914566,
      1.684110,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      1.780778,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3.523354,
      5.965973,
      2,
      0,
      0,
      NULL,
      1,
      0.040170,
      NULL);
commit;
end;
/


