set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '4122322',
      34,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.800040,
      1,
      1,
      2.651562,
      1.098764,
      1,
      0,
      1.572710,
      2.629981,
      1,
      0,
      NULL,
      0,
      0,
      0.674424,
      1,
      NULL,
      0.955324,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.337169,
      0.353596,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.850761,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.497292,
      1,
      5.798048,
      1,
      NULL,
      0,
      1,
      0.464685,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.202879,
      NULL,
      0,
      NULL,
      1.058083,
      1.673773,
      0.282323,
      1.481272,
      0.802637,
      1,
      1,
      NULL,
      NULL,
      0.452888,
      0,
      1,
      1.392865,
      NULL,
      1,
      NULL,
      1.571435,
      NULL,
      1.146089,
      1.611938,
      1,
      NULL,
      NULL,
      0.634727,
      2.796823,
      2,
      NULL,
      0,
      0,
      0.043613,
      NULL,
      0,
      NULL,
      3,
      NULL,
      5.735993,
      2.333780,
      5.992615,
      3.027340,
      NULL,
      NULL,
      0,
      1.362633,
      1.827742,
      1,
      NULL,
      NULL,
      5.199057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241803,
      NULL,
      1,
      0,
      0.300429,
      0.430332,
      NULL,
      1.188805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.304537,
      1,
      1.720557,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      4,
      1,
      4,
      1.734456,
      NULL,
      NULL,
      0,
      7.200347,
      1.460155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.700132,
      3,
      2,
      2.418169,
      0,
      1.885494,
      NULL,
      3.692276,
      0.110037,
      0.490382,
      0.938270,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '31032',
      NULL,
      '',
      0.131826,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


