set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '1301313',
      68.248500,
      1,
      0.408531,
      NULL,
      '204133',
      NULL,
      ' 5-21-1975',
      51,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      0.756786,
      1,
      0.937747,
      NULL,
      1,
      1,
      1.144428,
      0.641184,
      0,
      1.702697,
      NULL,
      NULL,
      1,
      0,
      0.211700,
      1.037235,
      NULL,
      0,
      3.170454,
      0,
      1,
      0.064688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083479,
      1.527574,
      NULL,
      0.590358,
      0,
      1,
      1,
      3.293712,
      1.949675,
      0,
      1.200197,
      0,
      0,
      1,
      0.139593,
      3.158540,
      0.299967,
      0.519824,
      2.747914,
      NULL,
      1.202449,
      1.172822,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.288032,
      0.363718,
      0.228015,
      1.809829,
      0.191665,
      NULL,
      1,
      NULL,
      NULL,
      0.903901,
      NULL,
      0.486467,
      NULL,
      0.697849,
      1,
      NULL,
      1.028853,
      0,
      NULL,
      0,
      0.067701,
      1,
      NULL,
      1.382083,
      0.464305,
      NULL,
      0.965646,
      2,
      1.046455,
      0.336311,
      NULL,
      0,
      1,
      0.942469,
      0.218626,
      1.617830,
      NULL,
      NULL,
      2.460289,
      2,
      5.698577,
      2.051247,
      2.106136,
      1.282173,
      1.489454,
      NULL,
      1,
      0.821661,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287315,
      1,
      1,
      NULL,
      1,
      0.845629,
      0.059686,
      1.394005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392256,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967997,
      2.333844,
      0,
      NULL,
      NULL,
      NULL,
      2.993039,
      1,
      4,
      5,
      2,
      1,
      2.193293,
      1.260554,
      NULL,
      NULL,
      0.545726,
      4,
      0.061197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.355300,
      1.053086,
      NULL,
      1,
      NULL,
      1.461293,
      NULL,
      NULL,
      NULL,
      0,
      0.907961,
      1,
      0,
      1,
      0,
      1,
      0.770613,
      1.892073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.881540,
      '44314',
      '',
      '',
      1.858985,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


