set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '10',
      27.475829,
      9,
      NULL,
      52,
      NULL,
      3.354267,
      3,
      '143114',
      3.655951,
      ' 3-16-1995',
      42,
      2.995058,
      1,
      NULL,
      3,
      NULL,
      0.929396,
      NULL,
      0,
      3.395594,
      0,
      1,
      1,
      0.543894,
      1,
      2,
      3.253833,
      2.906371,
      NULL,
      1.435976,
      2.731133,
      NULL,
      NULL,
      0,
      0.726181,
      1.354612,
      5,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0.528730,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.498705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.502564,
      0.733880,
      NULL,
      0,
      NULL,
      0.935709,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705425,
      0.506567,
      NULL,
      0,
      1.199305,
      0.882813,
      0,
      1,
      1.119138,
      1,
      0.959156,
      NULL,
      0.650455,
      1.682854,
      NULL,
      0,
      0,
      NULL,
      1,
      0.530224,
      1,
      1.507112,
      1,
      NULL,
      0.006507,
      1.010795,
      0.061694,
      1.344394,
      1.790683,
      1,
      1,
      0,
      1,
      0,
      NULL,
      4.936260,
      1,
      9.389994,
      NULL,
      5,
      7.971547,
      2,
      6.417229,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      9.072703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.248120,
      NULL,
      0,
      NULL,
      0.456045,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599774,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722315,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.051750,
      0,
      NULL,
      NULL,
      4.039520,
      0,
      NULL,
      0.094369,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890544,
      3.104555,
      3,
      2,
      NULL,
      0,
      2,
      3,
      1,
      0.134800,
      3.082375,
      1,
      0.984909,
      NULL,
      NULL,
      1.887004,
      1,
      1.108314,
      NULL,
      1.896596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.905592,
      '34420',
      '',
      '',
      0.938681,
      '',
      '',
      '',
      5,
      NULL,
      '3313',
      '1312',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


