set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '04143123',
      16.469984,
      48.732151,
      '3034011',
      136.663167,
      2,
      2.916296,
      NULL,
      '034313',
      4,
      NULL,
      21,
      65.602316,
      1,
      NULL,
      1.261873,
      1.762838,
      1,
      0,
      0.867581,
      0,
      0.020318,
      0.423254,
      2,
      0,
      5.236549,
      0,
      0,
      0.474456,
      0,
      NULL,
      0.077608,
      0.216464,
      1,
      0.540658,
      0.315834,
      0,
      3,
      0,
      1.332455,
      0,
      1,
      0.930572,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.165000,
      1.158387,
      0.483461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.338801,
      1.548788,
      6,
      2.492302,
      0.008736,
      NULL,
      1,
      0,
      0.267538,
      1,
      0,
      0,
      0.105028,
      0,
      0.281270,
      NULL,
      1,
      0.509072,
      NULL,
      0,
      0.155119,
      NULL,
      NULL,
      NULL,
      0.131850,
      1,
      3.781825,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.506516,
      1,
      0.132424,
      1,
      0,
      2.721104,
      NULL,
      NULL,
      0,
      3,
      1,
      3.154579,
      0.712268,
      NULL,
      1.349337,
      1,
      NULL,
      NULL,
      9.489963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813027,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521602,
      NULL,
      NULL,
      0.322259,
      2.933215,
      1.829071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.915056,
      0.322372,
      1,
      0,
      0,
      1.705146,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753551,
      1.411150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.397089,
      3.302471,
      1.366806,
      1.371371,
      0.008442,
      1,
      1,
      NULL,
      1.957867,
      1,
      NULL,
      1.227914,
      1,
      0,
      0.330829,
      0.179705,
      1.061402,
      0.390691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.152197,
      '31300',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '2421',
      NULL,
      '32240',
      4,
      7.593382,
      0.791856,
      NULL,
      1,
      4,
      NULL,
      2,
      NULL);
commit;
end;
/


