set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34244210',
      38,
      38.529509,
      '3322024',
      65.456325,
      4,
      0.269673,
      0,
      NULL,
      1,
      NULL,
      18,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.697227,
      1,
      0.461494,
      0.357092,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1.215866,
      0,
      0,
      0.516150,
      NULL,
      1.471968,
      NULL,
      3.809070,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.606423,
      NULL,
      NULL,
      0.250515,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.154446,
      0.926628,
      0.516874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1.513854,
      4,
      1.112316,
      1,
      1,
      NULL,
      0,
      0.417812,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1.567124,
      0.777494,
      NULL,
      0.703675,
      0.208966,
      NULL,
      0.470142,
      NULL,
      NULL,
      0,
      1.329103,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147882,
      1.332016,
      0,
      1,
      NULL,
      4,
      3,
      5,
      NULL,
      3,
      NULL,
      3.809169,
      NULL,
      NULL,
      0.519814,
      NULL,
      0.945133,
      NULL,
      NULL,
      NULL,
      0.060227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752396,
      1,
      0,
      0,
      1,
      1,
      0.678193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520134,
      NULL,
      4.294309,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      2.245038,
      NULL,
      NULL,
      NULL,
      1.556107,
      NULL,
      NULL,
      1,
      1.051289,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2.877348,
      1.251356,
      0.110051,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0.517903,
      0.171479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '00001',
      '',
      '',
      1.878654,
      NULL,
      NULL,
      '',
      6.773361,
      '2233',
      '0122',
      '01221',
      NULL,
      5.227146,
      1,
      6,
      2,
      NULL,
      1,
      NULL,
      0);
commit;
end;
/


