set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '21130403',
      NULL,
      35.785647,
      '4131024',
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.756410,
      ' 4-15-1990',
      56,
      14,
      1.984506,
      NULL,
      0,
      1.377946,
      0.162585,
      0.212077,
      1.822398,
      0,
      1.826975,
      0,
      1,
      0.865291,
      5.787474,
      1,
      1.716981,
      3.463461,
      NULL,
      0.902280,
      1.359569,
      1,
      1.992047,
      0.730354,
      1,
      0,
      1,
      NULL,
      0.922658,
      2,
      1.420526,
      NULL,
      NULL,
      NULL,
      0.478246,
      NULL,
      NULL,
      0,
      0.675537,
      0.847429,
      0.180383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093618,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.331431,
      3,
      0,
      1,
      NULL,
      1.216982,
      0,
      NULL,
      NULL,
      1,
      1.579784,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1.719567,
      1,
      0,
      1.011222,
      NULL,
      0,
      1.053634,
      NULL,
      3,
      0.281473,
      NULL,
      5,
      1.605595,
      1.731194,
      NULL,
      0.101612,
      1,
      1,
      0,
      0,
      0.163927,
      1.056598,
      1,
      0,
      0,
      1,
      1.400539,
      0,
      1,
      NULL,
      NULL,
      1,
      1.430627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.351312,
      1,
      1,
      1.254665,
      1,
      0,
      1.503068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083492,
      NULL,
      NULL,
      NULL,
      0,
      1.610844,
      NULL,
      NULL,
      NULL,
      0.498520,
      NULL,
      0.393815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.395395,
      1.332284,
      0.381076,
      1,
      2,
      1,
      0,
      1,
      0.623459,
      1.721088,
      NULL,
      1.816437,
      1,
      0,
      0.372041,
      NULL,
      NULL,
      1.646523,
      1.331922,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '31410',
      '',
      '',
      0,
      '',
      '',
      '',
      0.157895,
      '',
      '',
      '',
      NULL,
      3.434052,
      2,
      2,
      3.417626,
      7,
      NULL,
      NULL,
      0);
commit;
end;
/


