set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '22404301',
      NULL,
      NULL,
      NULL,
      56,
      NULL,
      0,
      3,
      NULL,
      NULL,
      ' 4-29-1998',
      57,
      18.486464,
      0,
      NULL,
      1,
      0,
      0.505956,
      1.377190,
      0,
      1.343292,
      1.435649,
      0.312298,
      0.872726,
      NULL,
      3.381508,
      0,
      1.131351,
      0.736809,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0,
      0,
      1.995293,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.034733,
      0,
      NULL,
      1.605568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800269,
      1,
      NULL,
      2.539002,
      2,
      NULL,
      0,
      NULL,
      1,
      1.998069,
      NULL,
      0,
      1,
      0.142416,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.435785,
      0.398115,
      0,
      0,
      1.747070,
      2.934018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.981388,
      0.643175,
      1.902276,
      1.376114,
      1,
      1.729275,
      0,
      1,
      0.285675,
      1,
      0.813613,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.684122,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010331,
      1.643056,
      1,
      1,
      1.096840,
      0.020900,
      0,
      0.974159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.179449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.458641,
      0.552450,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.013429,
      3.875582,
      0,
      3,
      0.854791,
      0.749630,
      1.765172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.192849,
      0.173548,
      0,
      0,
      NULL,
      0.600605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '44020',
      '',
      '',
      1.376697,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      1,
      NULL,
      0,
      NULL,
      9,
      0.155301,
      3,
      3.653119);
commit;
end;
/


