set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225698';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1044',
      '10422211',
      45,
      9.513385,
      '2014212',
      163.653762,
      2,
      1,
      0,
      '040333',
      3,
      ' 5-17-1988',
      43,
      9,
      NULL,
      NULL,
      NULL,
      0.507074,
      2.383275,
      0.060605,
      0,
      1.571981,
      0,
      0,
      1,
      1,
      4,
      0,
      0.959725,
      3.255362,
      NULL,
      1.112315,
      1.620207,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1.454176,
      1,
      0.659420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662690,
      1.050946,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618928,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288934,
      NULL,
      2,
      5.853463,
      4.328477,
      NULL,
      NULL,
      0,
      1,
      1.070863,
      1,
      0,
      1,
      1.564459,
      1,
      NULL,
      1,
      0.499079,
      0,
      NULL,
      1.018329,
      NULL,
      NULL,
      NULL,
      1.484426,
      1,
      0,
      1.405863,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.527947,
      0.791452,
      1.615851,
      0.974091,
      0.160507,
      0,
      1,
      NULL,
      1,
      0.814014,
      NULL,
      NULL,
      1.253275,
      1.073706,
      NULL,
      NULL,
      7.905554,
      1.071662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968416,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877298,
      1,
      1.847993,
      1.389029,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.618125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692126,
      NULL,
      2.319714,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.756810,
      1.450826,
      1.609833,
      0,
      NULL,
      0,
      1.147695,
      NULL,
      0,
      1.879371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '12021',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      4,
      '0112',
      '11124',
      '2323',
      2.766506,
      0,
      2,
      5,
      NULL,
      3,
      3,
      1,
      2);
commit;
end;
/


