set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.169023,
      NULL,
      '011300',
      2,
      ' 0-23-2000',
      NULL,
      NULL,
      1,
      NULL,
      1.378957,
      0.207799,
      NULL,
      0,
      1.662007,
      1,
      0,
      0.783539,
      0,
      0,
      4,
      0,
      NULL,
      8,
      NULL,
      8.371621,
      5,
      3,
      3,
      2,
      2,
      3,
      3,
      NULL,
      NULL,
      0.197655,
      2.319685,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0,
      1,
      NULL,
      NULL,
      1.398161,
      3.431757,
      0,
      1.822073,
      2,
      3,
      NULL,
      2.283764,
      NULL,
      1.651169,
      1.393787,
      2.316137,
      1,
      2,
      10,
      3.326655,
      2.254135,
      5.217606,
      1,
      NULL,
      2,
      1.995232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.620919,
      0,
      5.764745,
      NULL,
      4,
      9,
      9,
      NULL,
      1,
      0,
      0,
      0,
      1,
      5.617337,
      1.811941,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      7,
      1,
      NULL,
      0.216470,
      8,
      NULL,
      4.915848,
      1.309263,
      0.677990,
      2.241814,
      0,
      NULL,
      0.750051,
      0,
      3,
      5.835141,
      0.583217,
      8,
      7,
      8,
      3.454862,
      6.340733,
      0.147249,
      NULL,
      3,
      1.231003,
      NULL,
      1.921921,
      0,
      6.133554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500551,
      0,
      2,
      0,
      1,
      1.470179,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.981504,
      0,
      NULL,
      NULL,
      NULL,
      0.185032,
      1,
      1,
      2,
      1.379952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.597766,
      NULL,
      0.016040,
      NULL,
      1.244726,
      1.224106,
      3,
      NULL,
      0.338217,
      3,
      1.898840,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.145643,
      0.490692,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.023141,
      '42001',
      '',
      NULL,
      1.736994,
      '',
      '',
      '',
      0.370902,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


