set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '0040232',
      1.145383,
      1,
      3,
      3,
      '402102',
      0.944045,
      ' 2-26-1974',
      52.513925,
      NULL,
      0.906598,
      NULL,
      2,
      3.375764,
      0.378992,
      1.358485,
      3,
      1,
      1.178001,
      0.484359,
      NULL,
      1.412222,
      1,
      0,
      NULL,
      0.671379,
      4,
      5,
      0.516009,
      5,
      0.995451,
      NULL,
      2,
      1.481753,
      NULL,
      NULL,
      1.931034,
      3.608122,
      NULL,
      0,
      NULL,
      NULL,
      1.548990,
      NULL,
      NULL,
      6,
      3,
      1,
      0,
      NULL,
      1.914156,
      NULL,
      1,
      0,
      0,
      3,
      2.544617,
      2,
      2.284944,
      1.158607,
      2,
      1,
      NULL,
      2.641115,
      6.399562,
      8,
      0.034021,
      5,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.803732,
      NULL,
      NULL,
      0,
      1.265387,
      5.391193,
      3.416431,
      NULL,
      5.997524,
      1,
      1.831652,
      0.712664,
      0,
      0.421226,
      1.750546,
      0.759985,
      8.669304,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      7,
      0,
      2,
      0.109369,
      4.531485,
      2.384275,
      NULL,
      0,
      0.461167,
      NULL,
      5,
      0.225635,
      NULL,
      NULL,
      4,
      5,
      0,
      1.520595,
      8,
      0.551464,
      NULL,
      6.693528,
      4.268515,
      1,
      1,
      1.937585,
      1,
      7.799217,
      0.980250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256958,
      2.052959,
      0,
      0,
      0,
      7.177782,
      1.073191,
      0.606093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773127,
      NULL,
      NULL,
      NULL,
      NULL,
      5.906209,
      0.771361,
      2,
      NULL,
      0,
      86.456212,
      NULL,
      1.342959,
      0.932991,
      NULL,
      NULL,
      NULL,
      0,
      1.315813,
      0,
      5,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.796655,
      NULL,
      1.383170,
      NULL,
      1.315601,
      NULL,
      NULL,
      0.154707,
      1,
      3.578843,
      2,
      1.700042,
      NULL,
      0,
      NULL,
      0.563543,
      NULL,
      1,
      0,
      0.419244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '12132',
      '',
      '',
      1.420338,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


