set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '3210420',
      12.787454,
      NULL,
      3,
      0,
      '114112',
      NULL,
      NULL,
      31,
      NULL,
      1,
      NULL,
      13.490483,
      1,
      0.409861,
      1,
      1.708930,
      NULL,
      0.221985,
      NULL,
      NULL,
      0.347322,
      5.542933,
      0.651652,
      0.765494,
      4,
      0.692015,
      0,
      NULL,
      0.250628,
      NULL,
      0.643618,
      NULL,
      NULL,
      9,
      1,
      3,
      0.205921,
      0.001036,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.103320,
      NULL,
      NULL,
      0,
      1,
      3,
      0.680695,
      0,
      1.249028,
      NULL,
      0.771563,
      0.628149,
      1,
      1,
      0,
      0,
      1,
      1,
      1.690931,
      NULL,
      NULL,
      0.776211,
      9.502058,
      1,
      1,
      1,
      0.150998,
      NULL,
      NULL,
      1.541321,
      NULL,
      NULL,
      0.032097,
      3.540104,
      NULL,
      6,
      9.534208,
      NULL,
      1,
      NULL,
      0,
      1.320633,
      NULL,
      0.090951,
      0,
      3.265151,
      NULL,
      0,
      1,
      0.044221,
      1,
      NULL,
      0.376110,
      NULL,
      0.801535,
      6,
      1.837926,
      0.899528,
      6,
      0,
      2.066754,
      1.742021,
      3,
      1.185668,
      0,
      1.848145,
      7,
      0.958807,
      1,
      5.757868,
      NULL,
      8.510633,
      NULL,
      3.897680,
      5.072140,
      10,
      6.202309,
      NULL,
      1,
      7.647503,
      2.739465,
      0,
      0,
      4,
      0,
      3.329207,
      NULL,
      0.593759,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      1,
      1.826357,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.740981,
      0,
      NULL,
      1,
      NULL,
      130.921240,
      0.198625,
      NULL,
      0.906350,
      NULL,
      NULL,
      NULL,
      0.850760,
      0,
      NULL,
      1.901973,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.019693,
      1.526462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773641,
      NULL,
      2.971049,
      1,
      8,
      1.671914,
      NULL,
      3,
      0,
      NULL,
      0,
      0.738693,
      0,
      1.327077,
      1,
      0.239776,
      0,
      0,
      0.471538,
      1.959285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.382346,
      '22342',
      '',
      '',
      0,
      '',
      '',
      '',
      0.290808,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


