set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '0131440',
      4.816854,
      NULL,
      2,
      3,
      NULL,
      NULL,
      ' 4-26-1993',
      19.615399,
      NULL,
      1,
      NULL,
      NULL,
      2.262911,
      0.417879,
      1.567106,
      NULL,
      1,
      NULL,
      0,
      1.630780,
      0,
      1,
      0,
      0.619783,
      8,
      8,
      8,
      11.689153,
      NULL,
      0.924340,
      5,
      NULL,
      0.930294,
      8,
      3,
      5,
      NULL,
      3.345955,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.100707,
      NULL,
      1,
      2.520941,
      1,
      3,
      NULL,
      3.479960,
      1.625056,
      1.054947,
      0.181042,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.560769,
      7,
      2,
      2,
      1,
      0.584508,
      NULL,
      NULL,
      1.465883,
      NULL,
      NULL,
      0,
      2.931629,
      5,
      0.330899,
      NULL,
      1,
      NULL,
      1.586565,
      1.718038,
      0,
      1,
      0.999812,
      NULL,
      NULL,
      1.780335,
      0.696405,
      0,
      1.804964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      0.726773,
      NULL,
      0.712620,
      0.812700,
      1.969425,
      1,
      2,
      NULL,
      0,
      4,
      6,
      0,
      1,
      9.005555,
      9,
      2.384792,
      1,
      4,
      5.282241,
      9,
      6,
      6.112041,
      4.777546,
      3,
      2.711109,
      0,
      0,
      7,
      4,
      0,
      NULL,
      0,
      0.816843,
      0.637428,
      1,
      3.278592,
      0,
      2,
      2,
      NULL,
      1,
      1.356726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.499350,
      1.511168,
      0,
      3.901100,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.824495,
      1,
      2,
      1,
      1.306461,
      2,
      1.256047,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.975411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.570451,
      1,
      NULL,
      0.246457,
      1,
      1,
      3.846990,
      1,
      1,
      NULL,
      NULL,
      0.863813,
      0,
      1.910666,
      0.244778,
      1.249574,
      1.013821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.429594,
      '13020',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


