set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '3414232',
      10,
      0,
      0.720043,
      1,
      '020004',
      0.218250,
      ' 2- 5-1996',
      1.092617,
      NULL,
      NULL,
      NULL,
      17,
      0,
      NULL,
      1.647605,
      1.787644,
      0.992850,
      0,
      0,
      1,
      0.805549,
      0,
      0.888050,
      0,
      6.008320,
      0.941946,
      1.963941,
      2.207881,
      2,
      NULL,
      NULL,
      NULL,
      0,
      5.204920,
      NULL,
      NULL,
      2.494987,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.234643,
      1,
      NULL,
      3.374762,
      0,
      0,
      3,
      1.314666,
      NULL,
      0.560646,
      0,
      1,
      NULL,
      3,
      1.524280,
      1,
      2,
      0,
      0,
      1,
      0.771113,
      0,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725950,
      NULL,
      1.862780,
      2,
      1,
      0.202476,
      0,
      1.902185,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1.248170,
      1.602509,
      1,
      NULL,
      NULL,
      1,
      7.822374,
      0,
      1.653029,
      NULL,
      1.334286,
      NULL,
      1,
      NULL,
      1,
      3,
      3,
      NULL,
      3.661875,
      0.016087,
      1,
      0,
      9.529614,
      9,
      NULL,
      1,
      2,
      NULL,
      NULL,
      6.029844,
      0,
      NULL,
      4.274791,
      NULL,
      0.013977,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617449,
      1.412663,
      NULL,
      NULL,
      NULL,
      1,
      1.910122,
      0.211603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096700,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.318427,
      0.926592,
      4.419400,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.468327,
      8.691209,
      1.228248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.712906,
      0,
      1.527519,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0.298432,
      1.006510,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '02141',
      '',
      '',
      1.224446,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


