set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.437832,
      0,
      '214401',
      0.482274,
      ' 3- 0-1995',
      6,
      NULL,
      1.687069,
      NULL,
      0.004643,
      1,
      0.784594,
      NULL,
      0.059540,
      0,
      1,
      NULL,
      1,
      0.150983,
      1.899064,
      1,
      1.943611,
      0.253960,
      2,
      4,
      4.769332,
      4,
      0.861637,
      NULL,
      1.159763,
      1.510368,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      0.762230,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.803037,
      0,
      NULL,
      NULL,
      1.972153,
      2,
      NULL,
      3.132766,
      NULL,
      0.689266,
      0.582056,
      1.191913,
      NULL,
      7,
      6,
      1,
      2,
      1,
      1.267874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.862110,
      NULL,
      0,
      NULL,
      0.119275,
      0.995829,
      1,
      0.167836,
      0,
      4.511465,
      NULL,
      1,
      1,
      1.329507,
      1,
      NULL,
      1,
      2.230718,
      1.060937,
      0.552359,
      NULL,
      NULL,
      5.556191,
      NULL,
      0.846411,
      1,
      NULL,
      1,
      1.091094,
      0.246950,
      5,
      0,
      4.594045,
      4,
      8,
      9.655093,
      4.550952,
      8.687927,
      3.132849,
      NULL,
      4.214308,
      9.110952,
      6,
      1,
      1.309106,
      1.600469,
      1.967379,
      5.575899,
      0.906743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893515,
      1,
      1,
      1.700858,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.346791,
      2,
      3.965726,
      0.533552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.462580,
      1.930067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.536192,
      1,
      1.673972,
      1,
      0.848267,
      0,
      1,
      1.667215,
      0,
      NULL,
      0.323970,
      1,
      0.590910,
      1.452957,
      1,
      NULL,
      0,
      NULL,
      0.073621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '21042',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.556817,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


