set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '1014131',
      29.332678,
      3,
      3,
      3,
      '423214',
      NULL,
      ' 3-29-2000',
      NULL,
      NULL,
      1.168019,
      NULL,
      6.260329,
      NULL,
      1.171067,
      NULL,
      1.784666,
      NULL,
      1,
      1,
      0.658927,
      NULL,
      1.711412,
      0,
      0,
      NULL,
      2,
      1,
      0.730653,
      1.507518,
      NULL,
      5.373296,
      NULL,
      0,
      2.751885,
      NULL,
      0.123725,
      0,
      2,
      1.460348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203934,
      5,
      NULL,
      0,
      NULL,
      1.645377,
      1,
      1.243012,
      0,
      1,
      2.283934,
      1,
      1.459774,
      3,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.116659,
      1.961011,
      3,
      1,
      0,
      0.153863,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.132316,
      0,
      3.239828,
      1,
      NULL,
      0.209112,
      1,
      0.417128,
      1,
      1,
      1,
      1,
      NULL,
      0.320651,
      0,
      NULL,
      0.949872,
      3.654262,
      0.958688,
      1,
      8,
      1.700133,
      6,
      0,
      3,
      5.316858,
      2,
      0.152214,
      1,
      NULL,
      1,
      0.056516,
      3,
      6,
      3,
      NULL,
      4.440338,
      6,
      1,
      5,
      8.560063,
      0,
      2,
      1,
      3,
      0.852424,
      1.441184,
      2.878966,
      0.324006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.602070,
      0.001518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.020744,
      0,
      NULL,
      0.142319,
      1560,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260382,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.531939,
      0.137965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323529,
      1.554763,
      NULL,
      1,
      0.969414,
      1.626796,
      NULL,
      3.045707,
      1.542802,
      NULL,
      1,
      1,
      1,
      0,
      0.592820,
      NULL,
      0,
      1,
      0,
      1.577622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


