set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      42.255749,
      1,
      0.733133,
      3,
      '231012',
      2,
      ' 8-26-1984',
      44.113938,
      NULL,
      1,
      NULL,
      NULL,
      1.744832,
      0,
      1,
      1,
      0.132516,
      NULL,
      0,
      3,
      1,
      NULL,
      0.130310,
      1.398015,
      2,
      0,
      NULL,
      0.083806,
      1.126049,
      3.863000,
      2.407467,
      1.342371,
      1.501685,
      0,
      1,
      2,
      0.461954,
      3.314335,
      0.422404,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.157292,
      1.782399,
      1,
      0,
      1.603058,
      0.916794,
      3,
      0,
      NULL,
      1.891385,
      1.058109,
      3.062001,
      NULL,
      2.902187,
      0.848125,
      NULL,
      0.207163,
      0.522435,
      0.007725,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      0.276096,
      1.267234,
      NULL,
      NULL,
      0.148353,
      NULL,
      NULL,
      0,
      1,
      1,
      0.415566,
      1.672811,
      0.573278,
      0.297035,
      0.540273,
      NULL,
      1,
      1.347367,
      0.815071,
      0,
      1.340703,
      1.526748,
      NULL,
      1,
      1,
      1.813527,
      NULL,
      0,
      4,
      0.302394,
      NULL,
      6,
      NULL,
      0.940526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.774826,
      NULL,
      3,
      1.526647,
      NULL,
      NULL,
      2.579377,
      NULL,
      NULL,
      4,
      NULL,
      2.978252,
      7.792722,
      0.563874,
      4,
      2.352913,
      NULL,
      NULL,
      1,
      0,
      0.995252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.037735,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008637,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.660143,
      1.861842,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.163432,
      0.873389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.791341,
      1,
      NULL,
      1.531519,
      1.208819,
      0,
      0.414703,
      1.710281,
      0.180205,
      0.510103,
      1.371513,
      1,
      1.898927,
      1.189064,
      1,
      0.150045,
      NULL,
      0.902244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.442983,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0.096251,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


