set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '3200231',
      26,
      1,
      2,
      1,
      '120011',
      NULL,
      ' 1- 5-2003',
      8,
      NULL,
      1,
      NULL,
      NULL,
      1.504213,
      0,
      0,
      1.622550,
      2.198306,
      NULL,
      0,
      NULL,
      0.722978,
      0.174118,
      1,
      1.939557,
      NULL,
      7,
      5.967906,
      NULL,
      NULL,
      0,
      1.766217,
      0.560298,
      NULL,
      7,
      NULL,
      4.975918,
      1.577950,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.557901,
      1.222254,
      1.280264,
      1,
      3.962056,
      2.817424,
      3.747712,
      3.541889,
      NULL,
      1,
      1,
      0,
      3,
      NULL,
      1.886078,
      NULL,
      0.758303,
      3.605006,
      0.518469,
      0,
      1.969079,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.253978,
      NULL,
      0,
      1.235266,
      1,
      4.362838,
      1.264626,
      1,
      0.306572,
      0,
      2,
      0.290163,
      5.329361,
      0,
      1.787620,
      0,
      1,
      1,
      NULL,
      1,
      8.727359,
      0,
      0.878234,
      4.816201,
      1,
      2,
      NULL,
      NULL,
      3.302824,
      NULL,
      5,
      1.428458,
      NULL,
      NULL,
      1.243939,
      NULL,
      5,
      5,
      8.168975,
      6.012678,
      8.412622,
      2.328792,
      NULL,
      3.373214,
      0.772595,
      5,
      0.775137,
      NULL,
      NULL,
      1,
      7.331056,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.805555,
      2,
      1,
      0,
      NULL,
      1.979334,
      1.637022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.557532,
      0,
      2,
      8.115173,
      0.067802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463887,
      9,
      1.648729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897157,
      NULL,
      0,
      1,
      0,
      0,
      0,
      3,
      1.620158,
      3.091288,
      NULL,
      0,
      0,
      1.944482,
      0,
      0.463689,
      1.048955,
      0,
      0.275138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1.351373,
      '',
      NULL,
      '',
      0.926057,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


