set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      44,
      1,
      0,
      NULL,
      NULL,
      1,
      ' 6-21-1988',
      30.736563,
      NULL,
      1.082491,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0.831666,
      0,
      NULL,
      NULL,
      2,
      0.023470,
      1.887707,
      1.805703,
      0.091417,
      3.380871,
      6.332690,
      NULL,
      1.694793,
      1,
      0,
      1.550013,
      1.741221,
      0,
      4.836424,
      0,
      3,
      1.886721,
      0,
      1.131354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607170,
      3,
      1.581497,
      0,
      0.926246,
      2.934442,
      3,
      1,
      1.446858,
      2.490186,
      1.739210,
      3.653634,
      2,
      0,
      0.861615,
      0,
      1.696862,
      1.763495,
      0,
      0,
      5.728418,
      1,
      0,
      2.791657,
      0.386646,
      NULL,
      NULL,
      0.404600,
      NULL,
      NULL,
      0,
      NULL,
      0.277452,
      1,
      NULL,
      NULL,
      3.664032,
      0,
      1,
      0,
      0.450331,
      NULL,
      0,
      2.189277,
      NULL,
      1.419380,
      0.470205,
      0.472543,
      0.677314,
      NULL,
      0,
      7,
      1,
      1,
      NULL,
      1,
      4,
      NULL,
      4.315105,
      0.143622,
      4,
      4.212242,
      0.172809,
      0.532865,
      NULL,
      1.538948,
      1.579697,
      5.924562,
      5,
      NULL,
      5,
      NULL,
      2.590390,
      6.459617,
      NULL,
      1,
      NULL,
      4.861496,
      2.548418,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.651948,
      0,
      1,
      1,
      0.068709,
      1.289859,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.178651,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1.748753,
      1.504527,
      1,
      0.804594,
      NULL,
      NULL,
      NULL,
      1.821075,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.541208,
      0.027306,
      3,
      1,
      1.323757,
      1,
      3.724904,
      1,
      1.225684,
      NULL,
      0,
      1.855411,
      NULL,
      0.146793,
      0,
      0.891464,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.579081,
      '23303',
      '',
      NULL,
      0.669616,
      '',
      '',
      NULL,
      1.898629,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


